
<?php
ini_set('display_errors', 0 );
error_reporting(0);
header('Content-type:application/json');
include "json_conexao.inc";

try {
  	$cSQL = "SELECT 
		CAST(p.ean_principal AS NUMERIC(18,0)) as CODIGO, 
		p.grupo_id as CODGRUPO, 
		p.nome_produto as DESCRICAO, 
		pc.preco_venda as PRECO_VEND,   
		p.tamanho as  TAMANHO, 
		CASE WHEN p.nome_produto like 'PIZZA%' then replace(p.nome_produto, 'PIZZA', '') ELSE '' END as COMPLEMENTO 
		FROM 
		produto p (nolock) 
		INNER JOIN grupo (nolock) g on (g.grupo_id = p.grupo_id)
		INNER JOIN produto_custo (nolock) pc on (pc.produto_id = p.produto_id and pc.empresa_id = 1) 
		where p.inativo = 'N' ";

    $query = $conn->prepare($cSQL);
    $query->execute();

    $lastx = array();
    $reg=0;
    for($i=0; $row = $query->fetch(); $i++)
    {
	 $reg = $reg + 1;
	 $lastx['produtos'][$i]['codproduto'] = $row['CODIGO'];
	 $lastx['produtos'][$i]['codgrupo'] = $row['CODGRUPO'];
	 $lastx['produtos'][$i]['descricao'] = sanitizeString($row['DESCRICAO']);
	 $lastx['produtos'][$i]['complemento'] = sanitizeString($row['COMPLEMENTO']);
	 $lastx['produtos'][$i]['precovenda'] = $row['PRECO_VEND'];
	 $lastx['produtos'][$i]['tamanho'] = $row['TAMANHO'];
    }

    if ($reg == 0){
	echo 'VASIO';
    }else{	
	 $lastx['produtos'][$reg]['codproduto'] = "0";
	 $lastx['produtos'][$reg]['codgrupo'] = "0";
	 $lastx['produtos'][$reg]['descricao'] = "PIZZA MISTA";
	 $lastx['produtos'][$reg]['complemento'] = "";
	 $lastx['produtos'][$reg]['precovenda'] = 0;
	 $lastx['produtos'][$reg]['tamanho'] = "";
	echo json_encode($lastx);
    }
    unset($pdo);
    unset($query);

	} catch (PDOException $e) {
    echo "Erro ao conectar: " . $e->getMessage();
}

function sanitizeString($string) {
	 $palavra  = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
     //$palavra = ereg_replace("[^a-zA-Z0-9_]", "", strtr($string, "�������������������������� ", "aaaaeeiooouucAAAAEEIOOOUUC_"));
	 // devolver a string
    return $palavra;
}
?>

